unit UWatek;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls;



const cMAX  = 10;
const cWAIT = 1000;

type
  MWatek = class(TThread)
  private
	 Memo              : TMemo; // tylko wskanik, nie usuwa
    Panel             : TPanel; // tylko wskanik, nie usuwa
    Numer_watku       : Integer;
	 MyCriticalSection : RTL_CRITICAL_SECTION;
    wykonuj           : Boolean;
    cyfra             : Integer;
  
  protected
    procedure   Execute; override;

  public
    procedure   Display();
    procedure   Counter();

	 constructor Create(CreateSuspended      : Boolean;
							  parMemo              : TMemo;
							  parPanel             : TPanel;
							  parNumer_watku       : Integer;
							  parMyCriticalSection : RTL_CRITICAL_SECTION);

  end;

implementation
{------------------------------------------------------------------------------}
constructor MWatek.Create(CreateSuspended      : Boolean;
                          parMemo              : TMemo;
                          parPanel             : TPanel;
                          parNumer_watku       : Integer;
                          parMyCriticalSection : RTL_CRITICAL_SECTION);
begin
	inherited Create(CreateSuspended);
	   
	Memo              := parMemo;
	wykonuj           := true;
	cyfra             := 1;
	numer_watku       := parNumer_watku;
	Panel             := parPanel;

	FreeOnTerminate   := true;

	MyCriticalSection := parMyCriticalSection;
end;

procedure MWatek.Display();
begin
   Panel.Caption := IntToStr(cyfra);
   Memo.Lines.Add(IntToStr(numer_watku) + '.' + IntToStr(cyfra));
end;

procedure MWatek.Counter();
begin
	Inc(cyfra);
end;

procedure MWatek.Execute();
begin
	EnterCriticalSection(&MyCriticalSection);

   try
      while wykonuj do
      begin
         Synchronize(Display);
         Synchronize(Counter);

         if (Terminated and (cyfra >= cMAX)) then
         begin
            wykonuj := false;
         end;

         Sleep(cWAIT);
      end;

      Synchronize(Display);
   finally
	   LeaveCriticalSection(&MyCriticalSection);
   end;

   Application.ProcessMessages();
end;

end.

